/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOMGT_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO MGT
    Task function list for configuration file

   Changes:

    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2010-04-07  B. Meyer     added instances of the PHYs to the startup parameters
                                to fix mantis #8857

    2010-03-17  B. Meyer     extended MGT startup parameters with names of PHYs to
                                fix mantis #9046
                             introduced parameter version v2

    2009-05-20  B. Meyer     renamed pszName to pszEddName
                             changed types of psz... elements to TLR_STR*

**************************************************************************************/
/**
 * @file PNIOMGT_Functionlist.h
 * @brief PNIO MGT - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNIOMGT</code>
 * of task.
 */
#ifndef __PNIO_MGT_FUNCTIONLIST_H
#define __PNIO_MGT_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNIOMGT
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_PNIOMGT
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_RESULT
TaskEnter_PNIOMGT
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_MGT_STARTUP_PARAM_VERSION    (1)
#define PNIO_MGT_STARTUP_PARAM_VERSION_V2 (2)
#define PNIO_MGT_STARTUP_PARAM_VERSION_V3 (3)
#define PNIO_MGT_STARTUP_PARAM_VERSION_V4 (4)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNIO_MGT_STARTUPPARAMETER_Ttag  PNIO_MGT_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNIO_MGT_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /** EDD name
   *
   * The member defines the name of Ethernet device driver, which
   * handles the access to an Ethernet port.
   */
  TLR_STR*   pszEddName;

  /** PHY 0 name
   *
   * The member defines the name of PHY device driver, which
   * handles the access to the PHY.
   */
  TLR_STR*   pszPhy0Name;

  /** PHY 1 name
   *
   * The member defines the name of PHY device driver, which
   * handles the access to the PHY
   */
  TLR_STR*   pszPhy1Name;

  /** PHY 0 instance
   *
   * The instance under which the PHY can be identified
   */
  TLR_UINT32 ulPhy0Instance;

  /** PHY 1 instance
   *
   * The instance under which the PHY can be identified
   */
  TLR_UINT32 ulPhy1Instance;

  /** EDD instance
   *
   * The instance under which the EDD can be identified
   */
  TLR_UINT32 ulEddInstance;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNIO_MGT_FUNCTIONLIST_H */
